/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.Arrays;
import java.util.List;
import org.sonar.graph.Dsm;

public final class DsmManualSorter<V> {
    private final Dsm<V> dsm;
    private final List<V> verticesInDesiredOrder;

    private DsmManualSorter(Dsm<V> dsm, List<V> verticesInDesiredOrder) {
        this.dsm = dsm;
        this.verticesInDesiredOrder = verticesInDesiredOrder;
    }

    public static <V> void sort(Dsm<V> dsm, List<V> vertices) {
        DsmManualSorter<V> sorter = new DsmManualSorter<V>(dsm, vertices);
        super.sort();
    }

    public static <V> void sort(Dsm<V> dsm, V ... vertices) {
        DsmManualSorter.sort(dsm, Arrays.asList(vertices));
    }

    private void sort() {
        for (int desiredIndex = 0; desiredIndex < this.verticesInDesiredOrder.size(); ++desiredIndex) {
            int currentIndex = this.getCurrentIndex(this.verticesInDesiredOrder.get(desiredIndex));
            this.dsm.permute(currentIndex, desiredIndex);
        }
    }

    private int getCurrentIndex(V v) {
        for (int currentIndex = 0; currentIndex < this.dsm.getVertices().length; ++currentIndex) {
            if (!this.dsm.getVertices()[currentIndex].equals(v)) continue;
            return currentIndex;
        }
        throw new IllegalStateException("Vertex " + v + " is not contained in the DSM.");
    }
}

